using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Text;

namespace ClientHarness
{
   class Program
   {
      static void Main(string[] args)
      {
         SqlConnection conn = new SqlConnection(
           "data source=localhost; Integrated Security=True; Initial Catalog=SampleDB");
         conn.Open();

         Point3D origin = new Point3D();
         origin.X = 0;
         origin.Y = 0;
         origin.Z = 0;

         SqlCommand cmd = conn.CreateCommand();
         cmd.CommandText = "SELECT ObjectID, Name, Location FROM GameObjects";

         SqlDataReader rdr = cmd.ExecuteReader();
         while (rdr.Read())
         {
            Console.WriteLine("{0} ({1}) znajduje si w pooeniu: {2}. Odlego od punktu wyjciowego: {3}",
              rdr["ObjectID"], rdr["Name"], ((Point3D)rdr["Location"]).ToString(),
              ((Point3D)rdr["Location"]).DistanceFromPoint(origin));
         }

         rdr.Close();
         cmd.Dispose();
         conn.Close();

         Console.ReadLine();
      }
   }
}
